#include "serialization.h"
#include <map>

namespace maps::wiki::route_lost_feedback {

json::Value toJson(const geolib3::Point2& point)
{
    return json::Value(
        json::repr::ObjectRepr{
            {"type", json::Value("Point")},
            {"coordinates", json::Value({
                 json::Value(point.x()),
                 json::Value(point.y())
             })}
        }
    );
}

json::Value toJson(const jams::static_graph2::PersistentSegmentId& segment)
{
    return json::Value(
        json::repr::ObjectRepr{
            {"edgeId", json::Value(segment.edgeId().value())},
            {"segmentId", json::Value(segment.segmentIndex())}
        }
    );
}

jams::static_graph2::PersistentSegmentId fromJson(const json::Value& json)
{
    return jams::static_graph2::PersistentSegmentId(
        jams::static_graph2::LongId(json["edgeId"].as<uint64_t>()),
        json["segmentId"].as<uint64_t>()
    );
}

} // namespace maps::wiki::route_lost_feedback
