#pragma once

#include <mapreduce/yt/interface/client.h>
#include <boost/date_time/gregorian/gregorian.hpp>
#include <optional>
#include <string>
#include <vector>

namespace maps::wiki::route_lost_feedback {

struct YtTmpTableNames
{
    std::string routeLostClusters;
    std::string routeLostClustersSorted;
    std::string trackStat;
    std::string trackStatSorted;
    std::string routeLostJoinTrackStat;
    std::string routeLostScored;
    std::string routeLostScoredSorted;
};

YtTmpTableNames
createYtTmpTableNames();


struct YtInputTableNames
{
    std::vector<std::string> routeLost;
    std::vector<std::string> tracks;
};

YtInputTableNames
createYtInputTableNames(
    boost::gregorian::date_period period,
    NYT::IClient& client);

} // namespace maps::wiki::route_lost_feedback
