#include "track_stat_mapper_reducer.h"
#include "column_names.h"
#include "common.h"

#include <maps/libs/geolib/include/serialization.h>

namespace maps::wiki::route_lost_feedback {

TracksStatMapper::TracksStatMapper(const geolib3::Polygon2& polygon) :
    polygonBytes_ (geolib3::WKB::toBytes<geolib3::Polygon2>(polygon))
{
}

void TracksStatMapper::Do(TReader* reader, TWriter* writer)
{
    const auto polygon = geolib3::WKB::read<geolib3::Polygon2>(polygonBytes_);

    for (; reader->IsValid(); reader->Next()) {
        const NYT::TNode& row = reader->GetRow();

        const geolib3::Point2 point(
            row[column_names::START_LON].AsDouble(),
            row[column_names::START_LAT].AsDouble()
        );

        if (!pointIsInsidePolygon(point, polygon)) {
            continue;
        }

        NYT::TNode res;
        res(column_names::PERSISTENT_ID, row[column_names::PERSISTENT_ID]);
        res(column_names::SEGMENT_INDEX, row[column_names::SEGMENT_INDEX]);
        writer->AddRow(res);
    }
}

REGISTER_MAPPER(TracksStatMapper);

void TracksStatReducer::Do(TReader* reader, TWriter* writer)
{
    auto row = reader->GetRow();

    uint64_t countRows = 0;
    for (; reader->IsValid(); reader->Next()) {
        countRows++;
    }

    writer->AddRow(
        NYT::TNode(std::move(row))(column_names::TRACKS_NUMBER, countRows)
    );
}

REGISTER_REDUCER(TracksStatReducer);

} // namespace maps::wiki::route_lost_feedback
