#pragma once

#include <maps/libs/geolib/include/polygon.h>
#include <mapreduce/yt/interface/client.h>

namespace maps::wiki::route_lost_feedback {

class TracksStatMapper : public NYT::IMapper<
    NYT::TTableReader<NYT::TNode>,
    NYT::TTableWriter<NYT::TNode>>
{
public:
    Y_SAVELOAD_JOB(polygonBytes_);

    TracksStatMapper() = default;
    TracksStatMapper(const geolib3::Polygon2& polygon);

    void Do(TReader* reader, TWriter* writer) override;

private:
    std::vector<uint8_t> polygonBytes_;
};


class TracksStatReducer : public NYT::IReducer<
    NYT::TTableReader<NYT::TNode>,
    NYT::TTableWriter<NYT::TNode>>
{
public:
    TracksStatReducer() = default;
    void Do(TReader* reader, TWriter* writer) override;
};

} // namespace maps::wiki::route_lost_feedback
