#pragma once

#include <maps/libs/geolib/include/polygon.h>
#include <maps/libs/pgpool/include/pgpool3.h>
#include <mapreduce/yt/interface/client.h>
#include <boost/date_time/gregorian/gregorian.hpp>
#include <optional>

namespace maps::wiki::route_lost_feedback {

struct WorkerArgs
{
    geolib3::Polygon2 polygonGeo;
    boost::gregorian::date_period datesPeriod;
    uint64_t maxFeedbackTasksToPost;

    WorkerArgs();
};


class Worker
{
public:
    Worker(
        WorkerArgs args,
        pgpool3::Pool& socialPool
    );

    uint64_t createFeedbackTasks();

private:
    WorkerArgs args_;
    pgpool3::Pool& socialPool_;
};

} // namespace maps::wiki::route_lost_feedback
