#include "yt_last_dates.h"
#include "yt_consts.h"

#include <maps/libs/common/include/exception.h>
#include <yandex/maps/wiki/common/yt.h>
#include <mapreduce/yt/interface/client.h>

#include <vector>
#include <algorithm>

namespace bg = boost::gregorian;

namespace maps::wiki::route_lost_feedback {

namespace {

bg::date lastTableDateInDir(const std::string& dir)
{
    auto ytClient = common::yt::createYtClient(TString(YT_PROXY));

    std::vector<bg::date> days;
    for (const auto& day : ytClient->List(TString(dir))) {
        days.push_back(bg::from_string(day.AsString()));
    }

    ASSERT(!days.empty());
    return *std::max_element(days.begin(), days.end());
}

}

bg::date lastMatchedTracksDate()
{
    return lastTableDateInDir(YT_TRACKS_DIR);
}

bg::date lastRouteLostDate()
{
    return lastTableDateInDir(YT_ROUTE_LOST_DIR);
}

} // namespace maps::wiki::route_lost_feedback
