#pragma once

#include "table_names.h"
#include <maps/libs/geolib/include/polygon.h>
#include <mapreduce/yt/interface/client.h>

namespace maps::wiki::route_lost_feedback {

class YtOperations
{
public:
    YtOperations(
        NYT::IClientPtr client,
        geolib3::Polygon2 polygonGeo,
        YtInputTableNames inputTables,
        YtTmpTableNames tmpTables);

    // for test purposes
    //
    void clusterRouteLosts();
    void calcTrackStat();
    void sortRouteLostClusters();
    void sortTrackStat();
    void sortRouteLostScored();
    void evalRouteLostScored();
    void joinRouteLostAndTracks();

    void runAll();

private:
    NYT::IClientPtr client_;
    geolib3::Polygon2 polygonGeo_;
    YtInputTableNames inputTables_;
    YtTmpTableNames tmpTables_;
};

void sortByGivenСolumns(
    NYT::IClient& client,
    const std::string& inputTable,
    const std::string& outputTable,
    const NYT::TSortColumns& columns);

} // namespace maps::wiki::route_lost_feedback
