#pragma once

#include "action.h"

namespace maps::wiki::schedule_feedback {

struct EntranceRejectAction {

    enum class Reason {
        NameNotInteger,
        NumberTooBig,
        EntranceExistNearby,
        DuplicateFeedback,
        FarawayFromBuilding
    };

    Reason reason;
};

struct EntranceNoneAction {};

using EntranceAction = std::variant<
    EntranceRejectAction,
    EntranceNoneAction
>;

Action convertToAction(const EntranceAction& entranceAction);

} // namespace maps::wiki::schedule_feedback
