#pragma once

#include "../def.h"
#include "entrance_action.h"

#include <yandex/maps/wiki/social/feedback/gateway_ro.h>
#include <maps/libs/chrono/include/time_point.h>

#include <pqxx/transaction_base>

namespace maps::wiki::schedule_feedback {

struct EntranceFb
{
    TId feedbackId;
    chrono::TimePoint createdAt;
    geolib3::Point2 positionMerc;
    ObjId addressObjectId;
    uint64_t number;
};

struct ExtractEntranceNameError : public maps::Exception {};
struct EntranceObjectIdNotExist : public maps::Exception {};

EntranceFb socialTaskToEntrance(
    const social::feedback::Task& task);

bool entranceNumberIsTooBig(
    const EntranceFb& entrance,
    uint64_t maxAllowedNumber);

bool entranceExistsInVicinity(
    const EntranceFb& entrance,
    double vicinityRadiusGeo,
    pqxx::transaction_base& coreReadTxn);

bool isDuplicateWithPreviousSocialFeedback(
    const EntranceFb& entrance,
    social::feedback::GatewayRO& gatewayRo);

bool farawayFromAnyBuilding(
    const EntranceFb& entrance,
    double maxDistToBuildingGeo,
    pqxx::transaction_base& coreReadTxn);

EntranceAction entranceTaskHeuristicsAction(
    const social::feedback::Task& task,
    pqxx::transaction_base& coreReadTxn,
    social::feedback::GatewayRO& gatewayRo);

} // namespace maps::wiki::schedule_feedback
