#include "traits.h"
#include "action.h"
#include "entrance_heuristics.h"
#include "log_action.h"
#include "processing.h"
#include "report_addr_heuristics.h"
#include "report_addr_strategy.h"
#include "../util.h"

#include <yandex/maps/wiki/social/feedback/agent.h>
#include <yandex/maps/wiki/social/feedback/gateway_rw.h>
#include <yandex/maps/wiki/social/feedback/task_patch.h>
#include <yandex/maps/wiki/common/robot.h>

#include <maps/libs/log8/include/log8.h>

namespace maps::wiki::schedule_feedback {

namespace sf = social::feedback;

namespace {

Action fbapiTaskHeuristicsAction(
    const sf::Task& task,
    pqxx::transaction_base& /*txnCoreRead*/,
    sf::GatewayRO& /*gatewayRo*/)
{
//  TODO: remove commented code in https://st.yandex-team.ru/NMAPS-14637
//
//  if (isAddEntranceTask(task)) {
//      return convertToAction(entranceTaskHeuristicsAction(
//          task, txnCoreRead, gatewayRo
//      ));
//  }
//  if (isAddressReportAddressTask(task)) {
//      return convertToAction(reportAddressTaskHeuristicsAction(
//          task, txnCoreRead
//      ));
//  }
//  if (isAddressReportLocationTask(task)) {
//      return RejectAction{
//          "Everyone knows that 'address report location' is garbage"
//      };
//  }

    if (hasBadPhotos(task)) {
        return RejectAction{sf::RejectReason::AutoCleanWeb};
    }

    if (isFraudFeedback(task)) {
        return RejectAction{sf::RejectReason::AutoCleanWeb};
    }

    return NoneAction{};
}

ScheduleStatOne applyActionToFeedbackTask(
    [[maybe_unused]] sf::Agent& agent,
    [[maybe_unused]] const sf::TaskForUpdate& task,
    [[maybe_unused]] const Action& action)
{
    if (std::holds_alternative<RejectAction>(action)) {
        const auto& rejectReason = std::get<RejectAction>(action).reason;

        agent.resolveTaskCascade(task, sf::Resolution::createRejected(rejectReason));

        logFeedbackRejectionReason(task.id(), rejectReason);
        return ScheduleStatOne().setRejected();

//    TODO: remove commented code in https://st.yandex-team.ru/NMAPS-14637
//
//    } else if (std::holds_alternative<AcceptAction>(action)) {
//        agent.resolveTaskCascade(task, sf::Resolution::createAccepted());
//
//        logFeedbackAccepting(task.id());
//        return ScheduleStat().incAccepted();
//    } else if (std::holds_alternative<HideAction>(action)) {
//        agent.hideTask(task);
//
//        logFeedbackHiding(task.id());
//        return ScheduleStat().incHide();
    } else if (std::holds_alternative<NoneAction>(action)) {
        return ScheduleStatOne();
    } else {
        REQUIRE(false, "Unknown type of action");
    }
}

} // anonymous

ScheduleStatOne processIncomingFbapiTasks(
    pqxx::transaction_base& txnCoreRead,
    sf::Agent& agent,
    const sf::TaskForUpdate& task)
{
    ASSERT(isFbapiTask(task));

    auto taskRevealed = requireExists(
        agent.revealTaskByIdCascade(task.id()));

    auto action = fbapiTaskHeuristicsAction(taskRevealed, txnCoreRead, agent.gatewayRo());
    return applyActionToFeedbackTask(agent, taskRevealed, action);
}

} // namespace maps::wiki::schedule_feedback
