#include "report_addr.h"

#include "traits.h"
#include <yandex/maps/wiki/social/feedback/attribute_names.h>
#include <maps/libs/common/include/exception.h>

namespace maps::wiki::schedule_feedback {

namespace sf = social::feedback;
namespace sfa = social::feedback::attrs;

ReportAddressFb socialTaskToReportAddressFb(const sf::Task& task)
{
    ASSERT(isFbapiTask(task));
    ASSERT(isAddressReportAddressTask(task));

    ASSERT(task.objectId());

    const auto &attrs = task.attrs();
    ASSERT(attrs.existCustom(sfa::STREET));
    ASSERT(attrs.existCustom(sfa::HOUSE));

    return ReportAddressFb {
        task.id(),
        task.createdAt(),
        task.position(),
        *task.objectId(),
        {attrs.getCustom(sfa::STREET), attrs.getCustom(sfa::HOUSE)}
    };
}

std::optional<ReportAddressFb>
socialTaskToReportAddressFbNoExcept(const sf::Task& task) try
{
    return socialTaskToReportAddressFb(task);

} catch (const LogicError&) {
    return std::nullopt;
}

} // namespace maps::wiki::schedule_feedback
