#pragma once

#include "address.h"
#include "../def.h"
#include <yandex/maps/wiki/social/feedback/task.h>
#include <maps/libs/geolib/include/point.h>
#include <maps/libs/chrono/include/time_point.h>

#include <optional>

namespace maps::wiki::schedule_feedback {

// This feedback type is always attached
// to object 'addr'. User reports
// 'right' address of object
//
struct ReportAddressFb
{
    TId feedbackId;
    chrono::TimePoint createdAt;
    geolib3::Point2 positionMerc;
    ObjId addressObjectId;
    RawAddress address;
};

ReportAddressFb socialTaskToReportAddressFb(const social::feedback::Task& task);

std::optional<ReportAddressFb> socialTaskToReportAddressFbNoExcept(
    const social::feedback::Task& task);

} // namespace maps::wiki::schedule_feedback
