#include "report_addr_action.h"

#include <maps/libs/common/include/exception.h>

namespace maps::wiki::schedule_feedback {

// TODO: remove commented code in https://st.yandex-team.ru/NMAPS-14637
// Do smth with convertingg deprecated string
// reject reasons to enum RejectReason from social lib
//
// namespace {
//
// std::string rejectReasonToStr(ReportAddrRejectAction::Reason rejectReason)
// {
//     switch (rejectReason) {
//         case ReportAddrRejectAction::Reason::NonNormalizable:
//             return "address can't be normalized";
//         case ReportAddrRejectAction::Reason::ObjectIsNotAddress:
//             return "object id is not address object id";
//         case ReportAddrRejectAction::Reason::AddressExist:
//             return "address already exists";
//         case ReportAddrRejectAction::Reason::DuplicateFeedback:
//             return "is duplicated with existing feedback";
//         case ReportAddrRejectAction::Reason::NoStreetNearby:
//             return "no street in vicinity";
//     }
// }
//
// } // unnamed namespace

Action convertToAction(const ReportAddrAction& action)
{
    if (std::holds_alternative<ReportAddrRejectAction>(action)) {
        return RejectAction{social::feedback::RejectReason::IncorrectData
           // rejectReasonToStr(
           //     std::get<ReportAddrRejectAction>(action).reason
           // )
        };
    } else if (std::holds_alternative<ReportAddrHideAction>(action)) {
        return HideAction{};
    } else if (std::holds_alternative<ReportAddrAcceptAction>(action)) {
        return AcceptAction{};
    } else if (std::holds_alternative<ReportAddrNoneAction>(action)) {
        return NoneAction{};
    } else {
        REQUIRE(false, "Unknown report addr action");
    }
}

} // namespace maps::wiki::schedule_feedback
