#pragma once

#include "action.h"

namespace maps::wiki::schedule_feedback {

struct ReportAddrRejectAction {

    enum class Reason {
        NonNormalizable,
        ObjectIsNotAddress,
        AddressExist,
        DuplicateFeedback,
        NoStreetNearby
    };

    Reason reason;
};

struct ReportAddrAcceptAction {};

struct ReportAddrHideAction {};

struct ReportAddrNoneAction {};

using ReportAddrAction = std::variant<
    ReportAddrRejectAction,
    ReportAddrAcceptAction,
    ReportAddrHideAction,
    ReportAddrNoneAction
>;

Action convertToAction(const ReportAddrAction& reportAddrAction);

} // namespace maps::wiki::schedule_feedback
