#include "report_addr_exist.h"

#include "address.h"
#include "address_normalizer.h"
#include "revision_adapter.h"

namespace maps::wiki::schedule_feedback {

AddressExistsChecker::AddressExistsChecker(
        std::unique_ptr<IRevisionAdapter> revision,
        std::unique_ptr<IAddressNormalizer> normalizer) :
    revision_(std::move(revision)),
    normalizer_(std::move(normalizer))
{}

bool AddressExistsChecker::addressExists(
    ObjId addressObjectId,
    const NormalizedAddress& addr) const
{
    RawAddress revAddr = revision_->addressOfAddressObject(addressObjectId);
    auto revAddrNorm = normalizer_->normalize(revAddr);
    if (!revAddrNorm) {
        return false;
    }
    return addr == revAddrNorm;
}

} // namespace maps::wiki::schedule_feedback
