#pragma once

#include "../def.h"
#include <memory>

namespace maps::wiki::schedule_feedback {

class IAddressNormalizer;
class IRevisionAdapter;
struct NormalizedAddress;


class IAddressExistsChecker
{
public:
    virtual bool addressExists(
        ObjId addressObjectId,
        const NormalizedAddress& addr) const = 0;

    virtual ~IAddressExistsChecker() = default;
};

class AddressExistsChecker : public IAddressExistsChecker
{
public:
    AddressExistsChecker(
        std::unique_ptr<IRevisionAdapter> revision,
        std::unique_ptr<IAddressNormalizer> normalizer);

    bool addressExists(
        ObjId addressObjectId,
        const NormalizedAddress& addr) const override;

private:
    std::unique_ptr<IRevisionAdapter> revision_;
    std::unique_ptr<IAddressNormalizer> normalizer_;
};

} // namespace maps::wiki::schedule_feedback
