#include "report_addr_has_street.h"

#include "address.h"
#include "address_normalizer.h"
#include "revision_adapter.h"
#include <yandex/maps/wiki/geom_tools/conversion.h>

namespace maps::wiki::schedule_feedback {

HasStreetChecker::HasStreetChecker(
        double vicinityRadiusGeo,
        std::unique_ptr<IRevisionAdapter> revision,
        std::unique_ptr<IAddressNormalizer> normalizer) :
    vicinityRadiusGeo_(vicinityRadiusGeo),
    revision_(std::move(revision)),
    normalizer_(std::move(normalizer))
{}

bool HasStreetChecker::hasStreetInVicinity(
    const geolib3::Point2& positionMerc,
    const NormalizedAddress& addr) const
{
    auto bbox = geom_tools::makeVicinityBboxMerc(positionMerc, vicinityRadiusGeo_);
    auto streets = revision_->streetNamesFromBBox(bbox);
    for (const auto& street : streets) {
        auto streetNorm = normalizer_->normalizeStreet(street);
        if (streetNorm && *streetNorm == addr.street) {
            return true;
        }
    }
    return false;
}

} // namespace maps::wiki::schedule_feedback
