#pragma once

#include "../def.h"
#include <maps/libs/geolib/include/point.h>

namespace maps::wiki::schedule_feedback {

class IAddressNormalizer;
class IRevisionAdapter;
struct NormalizedAddress;


class IHasStreetChecker
{
public:
    virtual bool hasStreetInVicinity(
        const geolib3::Point2& positionMerc,
        const NormalizedAddress& addr) const = 0;

    virtual ~IHasStreetChecker() = default;
};

class HasStreetChecker : public IHasStreetChecker
{
public:
    HasStreetChecker(
        double vicinityRadiusGeo,
        std::unique_ptr<IRevisionAdapter> revision,
        std::unique_ptr<IAddressNormalizer> normalizer);

    bool hasStreetInVicinity(
        const geolib3::Point2& positionMerc,
        const NormalizedAddress& addr) const override;

private:
    double vicinityRadiusGeo_;
    std::unique_ptr<IRevisionAdapter> revision_;
    std::unique_ptr<IAddressNormalizer> normalizer_;
};

// Experiment to temporary disable this heuristics
//
class StreetAlwaysExistsChecker : public IHasStreetChecker
{
    bool hasStreetInVicinity(
        const geolib3::Point2& positionMerc,
        const NormalizedAddress& addr) const override
    {
        Y_UNUSED(positionMerc);
        Y_UNUSED(addr);
        return true;
    }
};

} // namespace maps::wiki::schedule_feedback
