#include "report_addr_heuristics.h"

#include "address_normalizer.h"
#include "log_action.h"
#include "report_addr.h"
#include "report_addr_exist.h"
#include "report_addr_has_street.h"
#include "report_addr_obj_is_addr.h"
#include "report_addr_strategy.h"
#include "revision_adapter.h"

#include <maps/libs/common/include/exception.h>
#include <maps/libs/log8/include/log8.h>

#include <library/cpp/testing/unittest/env.h>
#include <util/system/env.h>

#include <memory>

namespace maps::wiki::schedule_feedback {

namespace {

const std::string DEFAULT_GRAMMAR_PATH =
    "/usr/lib/yandex/maps/wiki/schedule_feedback_worker/segmenter_grammar";

const double NO_STREET_RADIUS = 200.; // m

ReportAddressStrategy createStrategyWorkingInstance(
    pqxx::transaction_base& coreReadTxn)
{
    // hack for integration tests in context of
    // overall feedback processing
    std::string grammarPath = FromYaTest()
        ? BuildRoot() + "/maps/search/geocoder/segmenter/data"
        : DEFAULT_GRAMMAR_PATH;

    auto normalizer = std::make_unique<AddressNormalizer>(grammarPath);

    auto isAddrChecker = std::make_unique<ObjectIsAddressChecker>(
        std::make_unique<RevisionAdapter>(coreReadTxn)
    );

    auto existsChecker = std::make_unique<AddressExistsChecker>(
        std::make_unique<RevisionAdapter>(coreReadTxn),
        std::make_unique<AddressNormalizer>(grammarPath)
    );

    auto streetChecker = std::make_unique<HasStreetChecker>(
        NO_STREET_RADIUS,
        std::make_unique<RevisionAdapter>(coreReadTxn),
        std::make_unique<AddressNormalizer>(grammarPath)
    );

    return ReportAddressStrategy(
        std::move(normalizer),
        std::move(isAddrChecker),
        std::move(existsChecker),
        std::move(streetChecker)
    );
}

} // anonymous

ReportAddrAction reportAddressTaskHeuristicsAction(
    const social::feedback::Task& task,
    pqxx::transaction_base& coreReadTxn)
{
    auto reportAddressFb = socialTaskToReportAddressFbNoExcept(task);
    if (!reportAddressFb) {
        return ReportAddrNoneAction{};
    }

    auto strategy =
        createStrategyWorkingInstance(coreReadTxn);

    return strategy.action(*reportAddressFb);
}

} // namespace maps::wiki::schedule_feedback
