#pragma once

#include "../def.h"

namespace maps::wiki::schedule_feedback {

class IRevisionAdapter;

class IObjectIsAddressChecker
{
public:
    virtual bool isAddressObject(ObjId objectId) const = 0;
    virtual ~IObjectIsAddressChecker() = default;
};

class ObjectIsAddressChecker : public IObjectIsAddressChecker
{
public:
    ObjectIsAddressChecker(std::unique_ptr<IRevisionAdapter> revision);
    bool isAddressObject(ObjId objectId) const override;

private:
    std::unique_ptr<IRevisionAdapter> revision_;
};

} // namespace maps::wiki::schedule_feedback
