#pragma once

#include "report_addr_action.h"

#include <memory>

namespace maps::wiki::schedule_feedback {

class IObjectIsAddressChecker;
class IAddressExistsChecker;
class IAddressNormalizer;
class IHasStreetChecker;
struct ReportAddressFb;

class ReportAddressStrategy
{
public:
    ReportAddressStrategy(
        std::unique_ptr<IAddressNormalizer> normalizer,
        std::unique_ptr<IObjectIsAddressChecker> isAddrChecker,
        std::unique_ptr<IAddressExistsChecker> existsChecker,
        std::unique_ptr<IHasStreetChecker> hasStreetChecker);

    ReportAddrAction action(const ReportAddressFb& fb) const;

private:
    std::unique_ptr<IAddressNormalizer> normalizer_;
    std::unique_ptr<IObjectIsAddressChecker> isAddrChecker_;
    std::unique_ptr<IAddressExistsChecker> existsChecker_;
    std::unique_ptr<IHasStreetChecker> hasStreetChecker_;
};

} // namespace maps::wiki::schedule_feedback
