#include "revision_adapter.h"
#include "address.h"
#include "../revision/address.h"
#include "../revision/house.h"
#include "../revision/street.h"

namespace maps::wiki::schedule_feedback {

RevisionAdapter::RevisionAdapter(pqxx::transaction_base& coreTxn) :
    gateway_(coreTxn),
    snapshot_(gateway_.snapshot(gateway_.maxSnapshotId()))
{
}

std::vector<std::string>
RevisionAdapter::streetNamesFromBBox(const geolib3::BoundingBox& bboxMerc) const
{
    return revisionStreetNames(bboxMerc, snapshot_);
}

bool
RevisionAdapter::isAddressObject(ObjId objectId) const
{
    return isAddrObject(objectId, snapshot_);
}

RawAddress
RevisionAdapter::addressOfAddressObject(ObjId addressObjectId) const
{
    return {
        revisionStreetName(addressObjectId, snapshot_),
        revisionHouseName(addressObjectId, snapshot_)
    };
}

} // namespace maps::wiki::schedule_feedback
