#pragma once

#include "../def.h"
#include <yandex/maps/wiki/revision/revisionsgateway.h>
#include <maps/libs/geolib/include/bounding_box.h>

namespace maps::wiki::schedule_feedback {

struct RawAddress;

class IRevisionAdapter
{
public:
    virtual std::vector<std::string>
    streetNamesFromBBox(const geolib3::BoundingBox& bboxMerc) const = 0;

    virtual bool isAddressObject(ObjId objectId) const = 0;

    virtual RawAddress
    addressOfAddressObject(ObjId addressObjectId) const = 0;

    virtual ~IRevisionAdapter() = default;
};


class RevisionAdapter : public IRevisionAdapter
{
public:
    RevisionAdapter(pqxx::transaction_base& coreReadTxn);

    std::vector<std::string>
    streetNamesFromBBox(const geolib3::BoundingBox& bboxMerc) const override;

    bool isAddressObject(ObjId objectId) const override;

    RawAddress addressOfAddressObject(ObjId addressObjectId) const override;

private:
    revision::RevisionsGateway gateway_;
    revision::Snapshot snapshot_;
};

} // namespace maps::wiki::schedule_feedback
