#include "address.h"

namespace maps::wiki::schedule_feedback {

bool isAddrObject(
    ObjId objectId,
    const revision::Snapshot& snapshot)
{
    auto addrObject = snapshot.objectRevision(objectId);
    if (!addrObject) {
        return false;
    }

    const auto& attrs = addrObject->data().attributes;
    return attrs && attrs->count("cat:addr");
}

} // namespace maps::wiki::schedule_feedback
