#include "common.h"
#include <maps/libs/common/include/exception.h>

namespace maps::wiki::schedule_feedback {

namespace {

const std::string ROLE = "rel:role";
const std::string OFFICIAL = "official";

} // anonymous

std::string extractOfficialLocalName(
    ObjId objId,
    const std::string& catNm,
    const revision::Snapshot& snapshot)
{
    const auto CAT_NM = "cat:" + catNm;
    const auto CAT_IS_LOCAL = catNm + ":is_local";
    const auto CAT_NAME = catNm + ":name";

    std::vector<ObjId> slaveIds;
    for (const auto& rel : snapshot.loadSlaveRelations(objId)) {
        const auto& relData = rel.data().relationData;
        const auto& attrs = rel.data().attributes;
        ASSERT(relData);
        ASSERT(attrs);
        if (attrs->count(ROLE) && attrs->at(ROLE) == OFFICIAL) {
            slaveIds.push_back(relData->slaveObjectId());
        }
    }

    if (slaveIds.empty()) {
        return "";
    }

    for (const auto& objAndRev : snapshot.objectRevisions(slaveIds)) {
        const auto& rev = objAndRev.second;
        bool deleted = rev.data().deleted;
        const auto& attrs = rev.data().attributes;

        if (attrs && attrs->count(CAT_NM) && attrs->count(CAT_IS_LOCAL) && !deleted) {
            ASSERT(attrs->count(CAT_NAME));
            return attrs->at(CAT_NAME);
        }
    }
    return "";
}

} // namespace maps::wiki::schedule_feedback
