#include "schedule_stat.h"

#include <maps/libs/log8/include/log8.h>

namespace maps::wiki::schedule_feedback {

bool ScheduleStat::empty() const
{
    return !accepted_
        && !rejected_
        && !hide_
        && !revealOnly_
        && !error_;
}

void ScheduleStat::printInfo() const
{
    INFO() << "Tasks revealed only: " << revealOnly_;
    INFO() << "Tasks accepted: " << accepted_;
    INFO() << "Tasks rejected: " << rejected_;
    INFO() << "Tasks hidden: " << hide_;
    INFO() << "Tasks errors: " << error_;
}

ScheduleStatOne& ScheduleStatOne::operator+=(const ScheduleStatOne& rhs)
{
    accepted_ |= rhs.accepted_;
    rejected_ |= rhs.rejected_;
    hide_ |= rhs.hide_;
    error_ |= rhs.error_;
    return *this;
}

ScheduleStat& ScheduleStat::operator+=(const ScheduleStatOne& rhs)
{
    bool hasExtraOperation = false;
    if (rhs.accepted_) {
        incAccepted();
        hasExtraOperation = true;
    }
    if (rhs.rejected_) {
        incRejected();
        hasExtraOperation = true;
    }
    if (rhs.hide_) {
        incHide();
        hasExtraOperation = true;
    }
    if (rhs.error_) {
        incError();
        hasExtraOperation = true;
    }
    if (!hasExtraOperation) {
        incRevealOnly();
    }
    return *this;
}

} // namespace maps::wiki::schedule_feedback
