#pragma once

#include <stddef.h>

namespace maps::wiki::schedule_feedback {

class ScheduleStatOne;

class ScheduleStat
{
public:
    ScheduleStat& operator+=(const ScheduleStatOne& rhs);

    bool empty() const;
    void printInfo() const;

    ScheduleStat& incAccepted() { ++accepted_; return *this; }
    ScheduleStat& incRejected() { ++rejected_; return *this; }
    ScheduleStat& incHide() { ++hide_; return *this; }
    ScheduleStat& incRevealOnly() { ++revealOnly_; return *this; }
    ScheduleStat& incError() { ++error_; return *this; }

private:
    size_t accepted_ = 0;
    size_t rejected_ = 0;
    size_t hide_ = 0;
    size_t revealOnly_ = 0;
    size_t error_ = 0;
};

class ScheduleStatOne
{
public:
    ScheduleStatOne& operator+=(const ScheduleStatOne& rhs);

    ScheduleStatOne& setAccepted() { accepted_ = true; return *this; }
    ScheduleStatOne& setRejected() { rejected_ = true; return *this; }
    ScheduleStatOne& setHide() { hide_ = true; return *this; }
    ScheduleStatOne& setAutoclosedBarriers() { autoclosedBarriers_ = true; return *this; }
    ScheduleStatOne& setError() { error_ = true; return *this; }

private:
    bool accepted_ = false;
    bool rejected_ = false;
    bool hide_ = false;
    bool autoclosedBarriers_ = false;
    bool error_ = false;

    friend ScheduleStat;
};

} // namespace maps::wiki::schedule_feedback
