#pragma once

#include <maps/libs/pgpool/include/pgpool3.h>
#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/wiki/tasks/status_writer.h>
#include <yandex/maps/wiki/social/common.h>

namespace maps {
namespace wiki {
namespace schedule_feedback {

class Worker {
public:
    Worker(
        pgpool3::Pool& socialPool,
        pgpool3::Pool& corePool,
        pgpool3::Pool& viewTrunkPool,
        tasks::StatusWriter& statusWriter);

    void doTask();

private:
    void scheduleRoutine();
    void releaseOverdueRoutine();
    void rejectOverdueNeedInfoRoutine();

    pgpool3::Pool& socialPool_;
    pgpool3::Pool& corePool_;
    pgpool3::Pool& viewTrunkPool_;
    tasks::StatusWriter& statusWriter_;
};

} // schedule_feedback
} // wiki
} // maps
