#include "../fixtures.h"
#include "../../lib/revision/address.h"
#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/serialization.h>
#include <yandex/maps/wiki/revision/revisionsgateway.h>
#include <library/cpp/testing/unittest/registar.h>

namespace maps::wiki::schedule_feedback::tests {

using NewRevData = revision::RevisionsGateway::NewRevisionData;
const TId TEST_USER = 111;
geolib3::Point2 COORDS_ORIGIN(0., 0.);

namespace {

ObjId createNewAddress(
    const geolib3::Point2& pointMerc,
    pgpool3::Pool& pool)
{
    auto txn = pool.masterWriteableTransaction();
    revision::RevisionsGateway gtw(txn.get());

    auto objectRevisionId = gtw.acquireObjectId();

    revision::ObjectData objectData(
        revision::Attributes{{"cat:addr", "1"}},
        std::nullopt /* description */,
        geolib3::WKB::toString(pointMerc)
    );

    NewRevData address(objectRevisionId, objectData);

    gtw.createCommit(std::list<NewRevData>{address}, TEST_USER,
        {{"description", "data"}});

    txn->commit();
    return objectRevisionId.objectId();
}

} // namespace anonymous

Y_UNIT_TEST_SUITE(revision) {

Y_UNIT_TEST_F(is_addr_object, DBFixture)
{
    ObjId addrId = createNewAddress(COORDS_ORIGIN, pool());

    auto txn = pool().masterWriteableTransaction();
    revision::RevisionsGateway gtw(txn.get());
    auto snapshot = gtw.snapshot(gtw.maxSnapshotId());

    UNIT_ASSERT(isAddrObject(addrId, snapshot));
    UNIT_ASSERT(isAddrObject(addrId + 1, snapshot) == false);
}

} // Y_UNIT_TEST_SUITE(revision)

} // namespace maps::wiki::schedule_feedback::tests
