#pragma once

#include "../lib/fbapi/address_normalizer.h"
#include "../lib/fbapi/report_addr_exist.h"
#include "../lib/fbapi/report_addr_has_street.h"
#include "../lib/fbapi/report_addr_obj_is_addr.h"
#include "../lib/fbapi/revision_adapter.h"

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

using namespace testing;

namespace maps::wiki::schedule_feedback::tests {

struct AddressNormalizerMock : IAddressNormalizer
{
    MOCK_METHOD(std::optional<std::string>, normalizeStreet, (const std::string&), (const, override));
    MOCK_METHOD(std::optional<std::string>, normalizeHouse, (const std::string&), (const, override));
    MOCK_METHOD(std::optional<NormalizedAddress>, normalize, (const RawAddress&), (const, override));
    MOCK_METHOD(std::optional<NormalizedAddress>, normalize, (const std::string&), (const, override));
};

struct ObjectIsAddressCheckerMock : IObjectIsAddressChecker
{
    MOCK_METHOD(bool, isAddressObject, (ObjId), (const, override));
};

struct AddressExistsCheckerMock : IAddressExistsChecker
{
    MOCK_METHOD(bool, addressExists, (ObjId, const NormalizedAddress&), (const, override));
};

struct HasStreetCheckerMock : IHasStreetChecker
{
    MOCK_METHOD(bool, hasStreetInVicinity, (const geolib3::Point2&, const NormalizedAddress&), (const, override));
};

struct RevisionAdapterMock : IRevisionAdapter
{
    MOCK_METHOD(RawAddress, addressOfAddressObject, (ObjId), (const, override));
    MOCK_METHOD(bool, isAddressObject, (ObjId), (const, override));
    MOCK_METHOD(std::vector<std::string>, streetNamesFromBBox, (const geolib3::BoundingBox&), (const, override));
};

} // namespace maps::wiki::schedule_feedback::tests
