#include <maps/wikimap/mapspro/services/tasks_feedback/src/schedule_feedback_worker/lib/fbapi/traits.h>
#include <maps/wikimap/mapspro/libs/social/tests/helpers/fb_task_factory.h>
#include <maps/libs/http/include/test_utils.h>
#include <util/stream/output.h>
#include <sstream>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

namespace maps::wiki::schedule_feedback::tests {

namespace sf = social::feedback;

Y_UNIT_TEST_SUITE(is_antifraud) {

Y_UNIT_TEST(fraud)
{
    auto mockGetStatusesHandle = maps::http::addMock(
        "http://router-prod.clean-web.yandex.net/v2",
        [] (const maps::http::MockRequest& request) {
            UNIT_ASSERT_VALUES_EQUAL(
                maps::json::Value::fromString(request.body),
                maps::json::Value::fromString(R"({
                    "id": "123",
                    "jsonrpc": "2.0",
                    "method": "process",
                    "params": {
                        "body": {
                            "text": "user message",
                            "lat": 0,
                            "lon": 0,
                            "ip": "ip",
                            "puid": "1",
                            "fingerprint": "fingerprint",
                            "permalink": ""
                        },
                        "key": "123",
                        "service": "altay_feedback",
                        "type": "text"
                    }
                })")
            );
            const std::string response = R"({
                "jsonrpc": "2.0",
                "id": "",
                "result": {
                    "verdicts": [
                        {
                            "name": "strict",
                            "subsource": "online",
                            "value": true,
                            "entity": "permalink",
                            "source": "antifraud",
                            "key": ""
                        }
                    ],
                    "errors": {}
                }
            })";
            return maps::http::MockResponse{response};
        }
    );

   sf::Task task = sf::tests::FbTaskFactory()
        .type(sf::Type::Address)
        .id(123)
        .attrs(maps::json::Value::fromString(R"({
            "uid": "1",
            "ip": "ip",
            "fingerprint": "fingerprint",
            "userDataComment": "user message"
        })"))
        .create();
    UNIT_ASSERT(isFraudFeedback(task));
}

Y_UNIT_TEST(no_fraud)
{
    auto mockGetStatusesHandle = maps::http::addMock(
        "http://router-prod.clean-web.yandex.net/v2",
        [] (const maps::http::MockRequest& request) {
            UNIT_ASSERT_VALUES_EQUAL(
                maps::json::Value::fromString(request.body),
                maps::json::Value::fromString(R"({
                    "id": "123",
                    "jsonrpc": "2.0",
                    "method": "process",
                    "params": {
                        "body": {
                            "text": "user message",
                            "lat": 55.55,
                            "lon": 37.37,
                            "ip": "ip",
                            "puid": "1",
                            "fingerprint": "fingerprint",
                            "permalink": ""
                        },
                        "key": "123",
                        "service": "altay_feedback",
                        "type": "text"
                    }
                })")
            );
            const std::string response = R"({
                "jsonrpc": "2.0",
                "id": "123",
                "result": {
                    "verdicts": [
                    ],
                    "errors": {}
                }
            })";
            return maps::http::MockResponse{response};
        }
    );

   sf::Task task = sf::tests::FbTaskFactory()
        .type(sf::Type::Address)
        .id(123)
        .position({37.37, 55.55})
        .attrs(maps::json::Value::fromString(R"({
            "uid": "1",
            "ip": "ip",
            "fingerprint": "fingerprint",
            "userDataComment": "user message"
        })"))
        .create();

    UNIT_ASSERT(!isFraudFeedback(task));
}

} // has_bad_photos_ut suite

} // namespace maps::wiki::schedule_feedback::tests
