#include "../mocks.h"
#include "../../lib/fbapi/report_addr.h"

#include <library/cpp/testing/unittest/registar.h>

namespace maps::wiki::schedule_feedback::tests {

namespace {

const ObjId OBJ_ID{123};
const RawAddress RAW_ADDRESS{"raw", "address"};
const NormalizedAddress NORM_ADDRESS{"norm", "address"};

} // namespace anonymous

Y_UNIT_TEST_SUITE(report_address_exist) {

Y_UNIT_TEST(normalization_fail)
{
    auto rev = std::make_unique<RevisionAdapterMock>();
    EXPECT_CALL(*rev, addressOfAddressObject(_))
        .WillOnce(Return(RAW_ADDRESS));

    auto norm = std::make_unique<AddressNormalizerMock>();
    EXPECT_CALL(*norm, normalize(An<const RawAddress&>()))
        .WillOnce(Return(std::nullopt));

    AddressExistsChecker check(std::move(rev), std::move(norm));
    UNIT_ASSERT(check.addressExists(OBJ_ID, NORM_ADDRESS) == false);
}

Y_UNIT_TEST(match)
{
    auto rev = std::make_unique<RevisionAdapterMock>();
    EXPECT_CALL(*rev, addressOfAddressObject(OBJ_ID))
        .WillOnce(Return(RAW_ADDRESS));

    auto norm = std::make_unique<AddressNormalizerMock>();
    EXPECT_CALL(*norm, normalize(RAW_ADDRESS))
        .WillOnce(Return(NORM_ADDRESS));

    AddressExistsChecker check(std::move(rev), std::move(norm));
    UNIT_ASSERT(check.addressExists(OBJ_ID, NORM_ADDRESS));
}

Y_UNIT_TEST(mismatch)
{
    auto rev = std::make_unique<RevisionAdapterMock>();
    EXPECT_CALL(*rev, addressOfAddressObject(OBJ_ID))
        .WillOnce(Return(RAW_ADDRESS));

    auto norm = std::make_unique<AddressNormalizerMock>();
    EXPECT_CALL(*norm, normalize(RAW_ADDRESS))
        .WillOnce(Return(NormalizedAddress{"nenorm", "address"}));

    AddressExistsChecker check(std::move(rev), std::move(norm));
    UNIT_ASSERT(check.addressExists(OBJ_ID, NORM_ADDRESS) == false);
}

} // Y_UNIT_TEST_SUITE

} // namespace maps::wiki::schedule_feedback::tests
