#include "common.h"
#include "publish.h"

#include <string>

namespace maps::wiki::sprav_feedback {

namespace {

const std::string YT_TABLE = "//home/sprav/assay/tasker/walkers/maps/address_export";
const std::string LAST_PROCESSED_TABLE = "service.last_processed_pedestrian_addresses";

} // unnamed namespace

template <>
common::AdvisoryLockIds lockId<AddressData>()
{
    return common::AdvisoryLockIds::SPRAV_PEDESTRIAN_ADDRESSES;
}

template <>
std::string lastTimeTableName<AddressData>()
{
    return LAST_PROCESSED_TABLE;
}

template <>
std::string ytTableName<AddressData>()
{
    return YT_TABLE;
}

template <>
void processFunc(
    pqxx::transaction_base& ,
    const AddressData& addressData,
    const ProcessParams<AddressData>& config)
{
    publishAddress(config.socialUrl, addressData);
}

} // namespace maps::wiki::sprav_feedback
