#include "common.h"
#include "data.h"
#include <maps/wikimap/mapspro/services/tasks_feedback/src/sprav_pedestrian_feedback/lib/parser.h>

#include <maps/libs/enum_io/include/enum_io.h>
#include <maps/libs/common/include/exception.h>

#include <boost/lexical_cast.hpp>

namespace maps::wiki::sprav_feedback {

namespace {

const std::string PHOTOS = "photos";
const std::string ASSIGNMENT = "assignmentId";
const std::string PROB_ADDRESS = "prob-address";
const std::string INPUT_COORDS = "input-coordinates";
const std::string COMMENT = "comment";
const std::string HOUSE = "house";
const std::string ADDRESS = "main-address";
const std::string STATE = "state";
const std::string WORKER = "workerId";
const std::string PEDESTRIAN_TYPE = "pedestrianType";

const enum_io::Representations<AddressData::State>
PREDEFINED_STATES_STRINGS {
    {AddressData::State::Address, "address"},
    {AddressData::State::NoAddress, "no-address"},
    {AddressData::State::NeverDone, "never-done"}
};

} // unnamed namespace

DEFINE_ENUM_IO(AddressData::State, PREDEFINED_STATES_STRINGS);

template<>
std::optional<AddressData> buildDataFromTNode(const NYT::TNode& tableRow)
{
    AddressData retVal;

    retVal.photoUrls = photoUrlsFromNode(tableRow[PHOTOS]);
    retVal.submitTimeUnixMs = submitTime(tableRow);
    retVal.createdAtTimeUnixMs = rowTime(tableRow);
    retVal.assignmentId = optionalStringFromNode(tableRow[ASSIGNMENT]);
    retVal.probAddress = optionalStringFromNode(tableRow[PROB_ADDRESS]);
    retVal.inputGeo = reversedCoordsToPoint(tableRow[INPUT_COORDS].AsString());
    retVal.comment = optionalStringFromNode(tableRow[COMMENT]);
    retVal.house = optionalStringFromNode(tableRow[HOUSE]);
    retVal.address = optionalStringFromNode(tableRow[ADDRESS]);
    retVal.state = boost::lexical_cast<AddressData::State >(tableRow[STATE].AsString());
    retVal.spravUserId = optionalStringFromNode(tableRow[WORKER]);
    retVal.pedestrianType = tableRow[PEDESTRIAN_TYPE].AsString();

    return retVal;
}

} // namespace maps::wiki::sprav_feedback
