#pragma once

#include <maps/wikimap/mapspro/services/tasks_feedback/src/sprav_pedestrian_feedback/lib/common.h>

#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <maps/libs/geolib/include/point.h>
#include <yandex/maps/wiki/common/yt.h>

#include <string>
#include <optional>

namespace maps::wiki::sprav_feedback {

struct AddressData
{
    enum class State { Address, NoAddress, NeverDone };

    std::vector<std::string> photoUrls;
    uint64_t submitTimeUnixMs;
    uint64_t createdAtTimeUnixMs;
    std::optional<std::string> assignmentId;
    std::optional<std::string> probAddress;
    geolib3::Point2 inputGeo;
    std::optional<std::string> comment;
    std::optional<std::string> house;
    std::optional<std::string> address;
    State state;
    std::optional<std::string> spravUserId;
    std::string pedestrianType;
};

DECLARE_ENUM_IO(AddressData::State);

template<>
std::optional<AddressData> buildDataFromTNode(const NYT::TNode& tableRow);

} // namespace maps::wiki::sprav_feedback
