#pragma once

#include <yandex/maps/wiki/common/pg_advisory_lock_ids.h>
#include <yandex/maps/wiki/common/yt.h>

#include <pqxx/pqxx>
#include <string>
#include <optional>

namespace maps::wiki::sprav_feedback {

template<typename T>
common::AdvisoryLockIds lockId();

template<typename T>
std::string lastTimeTableName();

template<typename T>
std::string ytTableName();

template<typename T>
std::optional<T> buildDataFromTNode(const NYT::TNode& tableRow);

inline uint64_t rowTime(const NYT::TNode& tableRow)
{
    const std::string YT_ROW_TIME = "createdAt";
    return tableRow[YT_ROW_TIME].IntCast<uint64_t>();
}

inline uint64_t submitTime(const NYT::TNode& tableRow)
{
    const std::string YT_SUBMIT_TIME = "submitTs";
    return tableRow[YT_SUBMIT_TIME].IntCast<uint64_t>();
}

template <typename T>
class ProcessParams;

template <typename T>
uint64_t getRowTimeMs(const T& t)
{
    return t.createdAtTimeUnixMs;
}

template <typename T>
void processFunc(pqxx::transaction_base& coreTxn, const T& fb, const ProcessParams<T>& config);

} // namespace maps::wiki::sprav_feedback
