#include "common.h"
#include "publish.h"

#include <string>

namespace maps::wiki::sprav_feedback {

namespace {

const std::string YT_TABLE = "//home/sprav/assay/tasker/walkers/maps/entrances_export";
const std::string LAST_PROCESSED_TABLE = "service.last_processed_pedestrian_entrances";

} // unnamed namespace

template <>
common::AdvisoryLockIds lockId<EntrancesData>()
{
    return common::AdvisoryLockIds::SPRAV_PEDESTRIAN_ENTRANCES;
}

template <>
std::string lastTimeTableName<EntrancesData>()
{
    return LAST_PROCESSED_TABLE;
}

template <>
std::string ytTableName<EntrancesData>()
{
    return YT_TABLE;
}

template <>
void processFunc(
    pqxx::transaction_base& coreTxn,
    const EntrancesData& fb,
    const ProcessParams<EntrancesData>& config)
{
    publishEntrances(coreTxn, config.viewTrunkTxn, fb,
        config.socialUrl, config.editorUrl);
}

} // namespace maps::wiki::sprav_feedback
