#pragma once

#include <maps/wikimap/mapspro/services/tasks_feedback/src/sprav_pedestrian_feedback/lib/common.h>

#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <maps/libs/geolib/include/point.h>
#include <yandex/maps/wiki/common/yt.h>

#include <string>
#include <optional>

namespace maps::wiki::sprav_feedback {

struct Entrance
{
    geolib3::Point2 pointGeo;
    std::string name;
};

struct EntrancesData
{
    enum class State { Entry, NoEntry, NeverDone };

    std::optional<std::string> address;
    std::optional<std::string> comment;
    geolib3::Point2 pointGeo;
    std::vector<std::string> photoUrls;
    uint64_t submitTimeUnixMs;
    uint64_t createdAtTimeUnixMs;
    std::string assignmentId;
    std::string spravUserId;
    State state;
    std::optional<std::string> city;
    std::vector<Entrance> entrances;
};

DECLARE_ENUM_IO(EntrancesData::State);

template<>
std::optional<EntrancesData> buildDataFromTNode(const NYT::TNode& tableRow);

} // namespace maps::wiki::sprav_feedback
