#include "print_info.h"

#include <util/generic/typetraits.h>

#include <maps/libs/log8/include/log8.h>

namespace maps::wiki::sprav_feedback {

void printLog(const FeedbackPublishData& data)
{
    switch (data.reason) {
        case FeedbackReason::SuspiciousName:
            INFO() << "Entrance '" << data.entrance.name << "'"
                << " (founded at this point by pedestrian)"
                << " has suspicious name. Need to be verified."
                << " Feedback published.";
            break;

        case FeedbackReason::NoBuildingFound:
            INFO() << "Entrance '" << data.entrance.name << "'"
                << " (founded at this point by pedestrian)"
                << " is too far from any building."
                << " Feedback published.";
            break;

        case FeedbackReason::NameConflict:
            INFO() << "Entrance '" << data.entrance.name << "'"
                << " (founded at this point by pedestrian)"
                << " has name conflict with existing entrance nearby."
                << " Feedback published.";
            break;

        case FeedbackReason::DuplicateName:
            INFO() << "Entrance '" << data.entrance.name << "'"
                << " founded at this point by pedestrian."
                << " This name is duplicate within this building."
                << " Feedback published.";
            break;

        default:
            ERROR() << "Unexpected FeedbackReason '"
                << static_cast<int>(data.reason) << "'";
            break;
    }
}

void printLog(const CommitPublishData& data)
{
    std::visit([&](auto&& arg) {
        using T = std::decay_t<decltype(arg)>;
        if constexpr (std::is_same_v<T, geolib3::Point2>) {
            INFO() << "Entrance commited.";
        } else if constexpr (std::is_same_v<T, revision::DBID>) {
            INFO() << "Entrance name commited.";
        } else {
            static_assert(TDependentFalse<T>, "non-exhaustive visitor!");
        }
    }, data.entrance);
}

void printLog(SkipReason reason)
{
    switch (reason) {
        case SkipReason::Duplicate:
            INFO() << "This entrance already exists nearby"
                << " Skipped.";
            break;

        default:
            ERROR() << "Unexpected SkipReason '"
                << static_cast<int>(reason) << "'";
            break;
    }
}

void printCommitInfo(revision::DBID objectId)
{
    INFO() << "ObjectId: " << objectId;
}


} // namespace maps::wiki::sprav_feedback
