#pragma once

#include "data.h"
#include "publish_feedback.h"

#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <yandex/maps/wiki/revision/common.h>

#include <variant>

namespace maps::wiki::sprav_feedback {

struct FeedbackPublishData
{
    Entrance entrance;
    FeedbackReason reason;
};

enum class SkipReason {
    Duplicate
};

DECLARE_ENUM_IO(SkipReason);

struct CommitPublishData
{
    std::variant<geolib3::Point2, revision::DBID> entrance;
    std::string entranceName;
};

using PublishData = std::variant<FeedbackPublishData, CommitPublishData, SkipReason>;

PublishData processEntrance(
    pqxx::transaction_base& coreTxn,
    pqxx::transaction_base& viewTrunkTxn,
    const Entrance& entrance);

} // namespace maps::wiki::sprav_feedback
