#include "publish_commit.h"

#include <maps/libs/geolib/include/serialization.h>
#include <yandex/maps/wiki/common/robot.h>
#include <yandex/maps/wiki/revision/revisionsgateway.h>
#include <maps/wikimap/mapspro/libs/editor_client/include/instance.h>
#include <maps/libs/geolib/include/conversion.h>

namespace maps::wiki::sprav_feedback {

namespace {

const std::string CATEGORY_ENTRANCE = "poi_entrance";

const std::unordered_map<std::string, std::string> NAME_ATTRS_TEMPLATE{
    {"poi_nm:name_type", "official"},
    {"poi_nm:lang", "ru"},
    {"poi_nm:is_local", "1"}
};

void setName(editor_client::BasicEditorObject& object, std::string name)
{
    std::unordered_map<std::string, std::string> nameAttrs = NAME_ATTRS_TEMPLATE;
    nameAttrs["poi_nm:name"] = std::move(name);
    object.tableAttributes["poi_nm"].emplace_back(std::move(nameAttrs));
}

} // unnamed namespace

revision::DBID renameEntrance(
    const std::string& editorUrl,
    const revision::DBID objectId,
    const std::string& entranceName)
{
    editor_client::Instance eClient(editorUrl, common::ROBOT_UID);

    auto entranceObject = eClient.getObjectById(objectId);
    REQUIRE(entranceObject.categoryId == CATEGORY_ENTRANCE,
        "Entrance object expected by id = " << objectId);

    setName(entranceObject, entranceName);
    return eClient.saveObject(entranceObject).id;
}

revision::DBID createEntrance(
    const std::string& editorUrl,
    const geolib3::Point2& entrancePoint,
    const std::string& entranceName)
{
    editor_client::Instance eClient(editorUrl, common::ROBOT_UID);

    editor_client::BasicEditorObject newObject;
    newObject.categoryId = CATEGORY_ENTRANCE;
    newObject.setGeometryInMercator(entrancePoint);

    setName(newObject, entranceName);
    return eClient.saveObject(newObject).id;
}

} // namespace maps::wiki::sprav_feedback
