#pragma once

#include "data.h"

#include <yandex/maps/wiki/revision/common.h>
#include <maps/libs/enum_io/include/enum_io_fwd.h>

#include <string>
#include <optional>

namespace maps::wiki::sprav_feedback {

enum class FeedbackReason {
    EntryButNoData,
    CommentForEntry,
    CommentForNoEntry,
    NoEntryButData,
    SuspiciousName,
    NoBuildingFound,
    DuplicateName,
    NameConflict
};

DECLARE_ENUM_IO(FeedbackReason);

revision::DBID publishFeedback(
    const geolib3::Point2& geoPoint,
    const EntrancesData& data,
    const std::string& socialUrl,
    FeedbackReason reason,
    const std::optional<std::string>& entranceName = std::nullopt);

} // namespace maps::wiki::sprav_feedback
