#pragma once

#include <maps/wikimap/mapspro/libs/misc_point_to_bld/include/point_to_bld.h>
#include <maps/libs/geolib/include/point.h>
#include <yandex/maps/wiki/revision/revisionsgateway.h>

#include <vector>
#include <optional>

namespace maps::wiki::sprav_feedback {

struct RevisionEntrance
{
    revision::DBID poiEntranceId;
    geolib3::Point2 point;
    std::optional<std::string> name;
};

std::vector<RevisionEntrance> findEntrances(
    revision::RevisionsGateway& gtw,
    revision::DBID bldId,
    double accuracyInMeters);

// attract entrance point to building edge
std::optional<misc::PointToBldResult> getEdgePoint(
    pqxx::transaction_base& viewTrunkTxn,
    const geolib3::Point2& geoPoint,
    double searchRadiusInMeters);

} // namespace maps::wiki::sprav_feedback
