#include "common.h"
#include "post_to_social.h"

#include <string>

namespace maps::wiki::sprav_feedback {

namespace {

const std::string YT_TABLE = "//home/sprav/assay/tasker/walkers/maps/feedback_export";
const std::string LAST_PROCESSED_TABLE = "service.last_processed_sprav_feedback";

} // unnamed namespace

template <>
common::AdvisoryLockIds lockId<SpravFeedback>()
{
    return common::AdvisoryLockIds::SPRAV_PEDESTRIAN_FEEDBACK;
}

template <>
std::string lastTimeTableName<SpravFeedback>()
{
    return LAST_PROCESSED_TABLE;
}

template <>
std::string ytTableName<SpravFeedback>()
{
    return YT_TABLE;
}

template <>
void processFunc(pqxx::transaction_base& ,
    const SpravFeedback& fb,
    const ProcessParams<SpravFeedback>& config)
{
    publishFeedback(fb, config.socialUrl);
}

} // namespace maps::wiki::sprav_feedback
