#include "sprav_feedback.h"
#include "magic_strings.h"
#include <maps/wikimap/mapspro/services/tasks_feedback/src/sprav_pedestrian_feedback/lib/parser.h>

#include <yandex/maps/wiki/common/yt.h>

namespace maps::wiki::sprav_feedback {

namespace {

const std::string ADDRESS = "address";
const std::string ASSIGNMENT = "assignmentId";
const std::string COMMENT = "comment";
const std::string COORDS = "coordinates";
const std::string PHOTOS = "photos";
const std::string TYPE = "type";
const std::string WORKER = "workerId";

bool typeIsAllowed(const NYT::TNode& tableRow)
{
    std::string fbType = tableRow[TYPE].AsString();
    return fbType == NEW_ADDRESS_TYPE ||
           fbType == INCORRECT_ADDRESS_TYPE ||
           fbType == CHANGE_IN_BASE ||
           fbType == CHANGE_NOT_IN_BASE;
}

} // unnamed namespace

template <>
std::optional<SpravFeedback> buildDataFromTNode(const NYT::TNode& tableRow)
{
    if (!typeIsAllowed(tableRow)) {
        return std::nullopt;
    }

    SpravFeedback fb;

    fb.address = optionalStringFromNode(tableRow[ADDRESS]);
    fb.comment = optionalStringFromNode(tableRow[COMMENT]);
    fb.pointGeo  = reversedCoordsToPoint(tableRow[COORDS].AsString());
    fb.photoUrls = photoUrlsFromNode(tableRow[PHOTOS]);
    fb.submitTimeUnixMs = submitTime(tableRow);
    fb.createdAtTimeUnixMs = rowTime(tableRow);
    fb.spravTaskId = tableRow[ASSIGNMENT].AsString();
    fb.spravUserId = tableRow[WORKER].AsString();
    fb.spravFeedbackType = tableRow[TYPE].AsString();

    return fb;
}

} // namespace maps::wiki::sprav_feedback
