#pragma once

#include <maps/wikimap/mapspro/services/tasks_feedback/src/sprav_pedestrian_feedback/lib/common.h>

#include <maps/libs/geolib/include/point.h>
#include <yandex/maps/wiki/common/yt.h>

#include <string>
#include <optional>

namespace maps::wiki::sprav_feedback {

struct SpravFeedback
{
    std::optional<std::string> address;
    std::optional<std::string> comment;
    geolib3::Point2 pointGeo;
    std::vector<std::string> photoUrls;
    uint64_t submitTimeUnixMs;
    uint64_t createdAtTimeUnixMs;
    std::string spravTaskId;
    std::string spravUserId;
    std::string spravFeedbackType;
};

template<>
std::optional<SpravFeedback> buildDataFromTNode(const NYT::TNode& tableRow);

} // namespace maps::wiki::sprav_feedback
