#include "print_info.h"

#include <boost/date_time/posix_time/posix_time.hpp>
#include <maps/libs/log8/include/log8.h>

namespace maps::wiki::sprav_feedback {

namespace {

boost::posix_time::ptime unixMsToPTime(uint64_t unixMs)
{
    using namespace std::chrono;
    auto timePoint = system_clock::time_point(std::chrono::seconds(unixMs / 1000));
    return boost::posix_time::from_time_t(system_clock::to_time_t(timePoint));
}

} // namespace

void printLoadFromYtInfo(tasks_feedback::TimeIntervalMs timeIntervalMs)
{
    auto lowerHuman = boost::posix_time::to_simple_string(unixMsToPTime(timeIntervalMs.fromTime));
    auto upperHuman = boost::posix_time::to_simple_string(unixMsToPTime(timeIntervalMs.tillTime));

    INFO() << "Time interval of feedback that will be loaded: "
        << "(" << timeIntervalMs.fromTime << ", " << timeIntervalMs.tillTime << "). "
        << "Human readable analog: "
        << "(" << lowerHuman << ", " << upperHuman << "). ";
}

void printWorkerArguments(
    const std::string& lastTimeTableName,
    const std::string& ytTableName)
{
    INFO() << "Loading started. "
        << "YT table: '" << ytTableName << "'. "
        << "lasttime PG table: '" << lastTimeTableName << "'.";
}

void printLoadedSizeInfo(size_t dataSize)
{
    INFO() << "Loaded feedback size: " << dataSize;
}

void printSettingLastProccessedInfo(uint64_t timeValue)
{
    INFO() << "Last processed feedback time '" << timeValue << "' was set";
}

void printProcessingInfo(uint64_t timeValue)
{
    INFO() << "Processing feedback with time '" << timeValue << "'";
}

void printSuccessPublishInfo()
{
    INFO() << "Feedback was successfully processed.";
}

} // namespace maps::wiki::sprav_feedback
