#include "social.h"

#include <maps/libs/auth/include/tvm.h>
#include <maps/libs/common/include/environment.h>
#include <set>

namespace maps::wiki::sprav_feedback {

http::HeaderMap socialBackofficeHttpHeaders()
{
    static const std::set<common::Environment> ALLOWED_ENVIRONMENTS = {
        common::Environment::Stable,
        common::Environment::Testing,
        common::Environment::Unstable
    };

    http::HeaderMap headers;
    if (ALLOWED_ENVIRONMENTS.contains(common::getYandexEnvironment())) {
        static const auto tvmClient = auth::TvmtoolSettings().makeTvmClient();
        static const TString SOCIAL_BACKOFFICE_TVM_ALIAS = "social-backoffice";

        auto tvmTicket = tvmClient.GetServiceTicketFor(SOCIAL_BACKOFFICE_TVM_ALIAS);
        headers.emplace(auth::SERVICE_TICKET_HEADER, std::move(tvmTicket));
    }
    return headers;
}

} // namespace maps::wiki::sprav_feedback
