#include <maps/wikimap/mapspro/services/tasks_feedback/src/sync_fbapi_feedback_worker/lib/worker.h>

#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/log8/include/log8.h>
#include <yandex/maps/wiki/common/default_config.h>
#include <yandex/maps/wiki/common/extended_xml_doc.h>

#include <memory>

namespace {

const std::string MODULE_NAME = "wiki-sync-fbapi-feedback-worker";

} // anonymous namespace

int main(int argc, char* argv[]) try
{
    maps::cmdline::Parser parser;
    auto workerConfig = parser.string("config")
            .help("path to worker configuration");
    auto syslogTag = parser.string("syslog-tag")
            .help("redirect log output to syslog with given tag");
    auto statusDir = parser.string("status-dir")
            .help("path to status dir");

    parser.parse(argc, argv);

    if (syslogTag.defined()) {
        maps::log8::setBackend(maps::log8::toSyslog(syslogTag));
    }

    std::unique_ptr<maps::wiki::common::ExtendedXmlDoc> configXml;
    if (workerConfig.defined()) {
        configXml.reset(new maps::wiki::common::ExtendedXmlDoc(workerConfig));
    } else {
        configXml = maps::wiki::common::loadDefaultConfig();
    }

    maps::wiki::tasks::StatusWriter statusWriter(std::nullopt);
    if (statusDir.defined()) {
        statusWriter.reinit(statusDir, MODULE_NAME + ".status");
    }

    maps::wiki::sync_fbapi_feedback::Worker worker(*configXml, statusWriter);

    INFO() << "sync-fbapi-feedback-worker started";
    worker.doTask();
    return EXIT_SUCCESS;
} catch (const maps::Exception& e) {
    FATAL() << "Worker failed: " << e;
    return EXIT_FAILURE;
} catch (const std::exception& e) {
    FATAL() << "Worker failed: " << e.what();
    return EXIT_FAILURE;
}
