#include <maps/wikimap/mapspro/services/tasks_feedback/src/sync_fbapi_feedback_worker/lib/mt_router_client.h>
#include <maps/wikimap/mapspro/services/tasks_feedback/src/sync_fbapi_feedback_worker/lib/router_uri_client.h>
#include <maps/wikimap/mapspro/services/tasks_feedback/src/sync_fbapi_feedback_worker/lib/route.h>
#include <maps/wikimap/mapspro/services/tasks_feedback/src/sync_fbapi_feedback_worker/lib/decode_coordinates.h>

#include <string>
#include <cstdlib>
#include <iostream>

namespace mws = maps::wiki::sync_fbapi_feedback;
namespace mp = yandex::maps::proto;

namespace {

void printPoints(const maps::geolib3::PointsVector& points)
{
    std::cout << "size: " << points.size() << std::endl;
    std::cout.precision(17);
    for (const auto& point : points) {
        std::cout << "(" << point.x() << ", " << point.y() << ")" << std::endl;
    }
}

} // unnamed namespace

int main()
try {
    {
        // const std::string HOST = "http://core-bicycle-router.maps.yandex.net";  // stable
        const std::string HOST = "http://core-bicycle-router.testing.maps.n.yandex.ru";  // testing
        maps::http::URL url(HOST);

        mws::RouterConfig configuration(url);
        mws::ResolveUriFromRouterClient client(configuration);

        auto response = client.uri("ymapsbm1://route/bicycle/v1?37.598368%2C55.772060~CAISIAoKCOSOmDUQ_tLtIxIFCDQQ2AESBQhaEJYBEgQIchB2~37.598422%2C55.772485");
        std::cout << "Response from bicycle-router recieved" << std::endl;
        mws::Route dRoute(response);
        std::cout << "<routePoints>" << std::endl;
        printPoints(dRoute.routePointsGeodetic().points());
        std::cout << "</routePoints>" << std::endl;
    }
    {
        // const std::string HOST = "http://core-masstransit-router.maps.yandex.net";  // stable
        const std::string HOST = "http://core-masstransit-router.common.testing.maps.yandex.net";  // testing
        maps::http::URL url(HOST);

        mws::RouterConfig configuration(url);
        mws::MTRouterClient client(configuration);

        auto response = client.pedestrianUri("ymapsbm1://route/pedestrian?rll=37.594593%2C55.724557~37.593397%2C55.735292");
        std::cout << "Response from mt-router recieved" << std::endl;
        mws::Route dRoute(response);
        std::cout << "<routePoints>" << std::endl;
        printPoints(dRoute.routePointsGeodetic().points());
        std::cout << "</routePoints>" << std::endl;
    }
    {
        // const std::string HOST = "http://core-driving-router.maps.yandex.net";  // stable
        const std::string HOST = "http://core-driving-router.testing.maps.yandex.net";  // testing
        maps::http::URL url(HOST);

        mws::RouterConfig configuration(url);
        mws::ResolveUriFromRouterClient client(configuration);

        // from issue: https://feedback-admin.tst.c.maps.yandex-team.ru/task/3048d4f5-e22c-4646-a9b7-f8ae2dbdd5cf
        auto response = client.uri("ymapsbm1://route/driving/v1/CsQCCnD4zPIj8Ey4N5cO59wBx5YBzymvMM83lz-vYv_mAZc50F_QsAGofJgiqAGYGNAt3yn_M_8WiB_gML8ir2W_jAHvsgHXP7_tAe-gAdd_N99ElxWXb6-BAc9n11PgYPBF2FyQDJeUAeeGAf9_z0vvaecFEmXY-I81uAuQBLck8BLIDqcE3xqPJP8HwBrIQMApwEyQetBT2BioLJg82EnwPrg--A3IMoA56Cb4WPBM0GqAIOBvoEvQO-A7-C3IPtgkiCKYGfcX0GOoQPcmpxW3BN8EnwenAbgFGBpUY1iSAe4BmAKSAvMB0gHwAZUCpwKtAhUlJywDBxPbAtACuwLnAhImyQLFAsECugK1ArsCtAIluAItswKnAqYCzgEbHWGGAYgCigKJAv8BoQKRApECIggIABIEEBQYRiIJCDESBRA9GPcEEgAaAA");
        std::cout << "Response from driving-router recieved" << std::endl;
        mws::Route dRoute(response);
        std::cout << "<routePoints>" << std::endl;
        printPoints(dRoute.routePointsGeodetic().points());
        std::cout << "</routePoints>" << std::endl;
    }
    {
        auto decodedPoints = mws::decodeCoordinates("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");
        std::cout << "<decodedPoints>" << std::endl;
        printPoints(decodedPoints);
        std::cout << "</decodedPoints>" << std::endl;
    }
    return EXIT_SUCCESS;
} catch (std::exception& ex) {
    std::cerr << "ex: " << ex.what();
    return EXIT_FAILURE;
}
